if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)
local left_sensor = resize.location.left_sensor
local right_sensor = resize.location.right_sensor
local left_magnet = resize.location.left_magnet
local right_magnet = resize.location.right_magnet

local random_input_1 = Rectangle.new(resize.location.generate_red + Vector.new(2, 0))
local random_input_2 = Rectangle.new(resize.location.generate_blue + Vector.new(2, 0))
local output = resize.location.std.checkers[1].dispose:translate(Vector.new(-2, 0))

local default_vertical = 0.3;
state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

set_default_vertical(default_vertical)
function tutorial_routine_first()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    embed(ramp(4, do_all(
      announce_lambda("These inputs arrive at an inconsistent rate.", 0.08),
      bouncing_arrow_at_game_lambda(random_input_1, 0.06, LEFT),
      bouncing_arrow_at_game_lambda(random_input_2, 0.06, LEFT)
    ), captured_cancel()))
    embed(ramp(4, do_all(
      announce_lambda("We need to weld them in pairs.", 0.08),
      bouncing_arrow_at_game_lambda(output, 0.06, RIGHT)
    ), captured_cancel()))
    set_user_input_filter(only_play_filter)
    state:suppress_transport_menu(false);
    embed(pause(0.25))
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on the factory.", 0.1))
    ))
    embed(pause_until(function() return state.grid:ticks() >= 17 end))
    embed(announce("We need to balance the inputs electrically.", 5, 0.08, captured_cancel()))
    embed(ramp_until(function() return false end, do_all(
      announce_lambda("Try again", 0.1),
      highlight_menu_item_lambda("stop_button")
    )))
  end)
end
function wire_positions()
  local ret = {}
  for i,v in pairs(state.grid:entities()) do
    if v.type == "Wire" then
      if v.source.where == left_sensor then
        ret.left = true
      elseif v.source.where == right_sensor then
        ret.right = true
      end
    end
  end
  return ret
end
function wire_count()
  local ct = 0;
  for i, v in pairs(wire_positions()) do
    ct = ct + 1
  end
  return ct
end
function draw_missing_inputs_lambda()
  local a = bouncing_arrow_at_game_lambda(Rectangle.new(left_sensor), 0.06, UP)
  local b = bouncing_arrow_at_game_lambda(Rectangled.new(-0.5, 0, 0.5, 0.5):translate(right_sensor:as_vectord()), 0.06, RIGHT)
  return function(c, fade)
    local pos = wire_positions()
    if not pos.left then
      a(c, fade)
    end
    if not pos.right then
      b(c, fade)
    end
  end
end
function draw_corresponding_output_lambda()
  local a = bouncing_arrow_at_game_lambda(Rectangle.new(right_magnet), 0.06, RIGHT)
  local b = bouncing_arrow_at_game_lambda(Rectangle.new(left_magnet), 0.06, LEFT)
  local partial = state:get_partial_interaction()
  local left = true
  if partial.type == "PartialCreateWire" then
    if partial.source and partial.source.where == left_sensor then
      left = false
    end
  end
  return function(c, fade)
    if left then
      b(c, fade)
    else
      a(c, fade)
    end
  end
end
function only_wire_filter(i)
  return i == PlayerInteraction.wire
end
function is_wire_open()
  local partial = state:get_partial_interaction()
  return partial.type == "PartialCreateWire"
end
function is_done()
  return wire_count() == 2
end
local function wiring_status()
  local progress = wire_positions()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreateWire" then
    if not partial.source_set then
      if partial.source and partial.source.index == 1 then
        if not progress.left and partial.source.where == left_sensor then
          return "source okay"
        end
        if not progress.right and partial.source.where == right_sensor then
          return "source okay"
        end
      end
      return "source bad"
    else
      if partial.target then
        if partial.source.where == left_sensor and partial.target.where == right_magnet then
          return "target okay"
        end
        if partial.source.where == right_sensor and partial.target.where == left_magnet then
          return "target okay"
        end
      end
      return "target bad"
    end
  else
    return "not wiring"
  end
end
local function wiring_interaction_filter(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.rmb_click then
      return true
    elseif i.event == MouseEventAction.lmb_click then
      local status = wiring_status()
      return status == "source okay" or status == "target okay"
    end
  elseif i.type == "MouseUpdateAction" then
    return true
  end
  return i == PlayerInteraction.cancel or i == PlayerInteraction.wire
end
local first_wire_created = false
function speed_is_low()
  return state:get_simulation_speed() < 1.5;
end
function tutorial_routine_second()
  return coroutine.wrap(function()
    if not is_done() then
      embed(ramp(4, do_all(
        announce_lambda("Let's wire the sensors to the magnets.", 0.1)
      ), captured_cancel()))
      state:suppress_toolbar_menu(false);
      embed(pause(0.2))
    end
    while not is_done() or is_wire_open() do
      set_user_input_filter(only_wire_filter)
      embed(ramp_until(is_wire_open, do_all(
        announce_lambda("Tool: Wire", 0.2),
        highlight_menu_item_lambda("toolbar_8")
      )))
      set_user_input_filter(wiring_interaction_filter)
      if wire_count() < 1 then
        embed(ramp_while(
          function() return wiring_status() == "source bad" or wiring_status() == "source okay" end,
          do_all(
            announce_lambda("Click on a negative sensor node to create a wire.", 0.06),
            announce_lambda("The negative node is active when the sensor doesn't see anything.", 0.05, default_vertical - 0.06),
            draw_missing_inputs_lambda()
          )
        ))
        embed(ramp_while(
          function() return wiring_status() == "target bad" or wiring_status() == "target okay" end,
          do_all(
            announce_lambda("Click on the magnet to connect the wire.", 0.06),
            announce_lambda("When a magnet receives a signal, it holds on to whatever is in front of it.", 0.05, default_vertical - 0.07),
            draw_corresponding_output_lambda()
          )
        ))
        if not first_wire_created and wire_count() == 1 then
          first_wire_created = true
          embed(announce("This magnet will prevent objects from passing unless its sensor sees something.", 3, 0.05, captured_cancel()))
        end
      end
      if wire_count() == 1 then
        embed(ramp_while(
          function() return wire_count() == 1 and wiring_status() == "source bad" or wiring_status() == "source okay" end,
          do_all(
            announce_lambda("Click on the other negative sensor node to create a wire.", 0.06),
            announce_lambda("The negative node is active when the sensor doesn't see anything.", 0.05, default_vertical - 0.06),
            draw_missing_inputs_lambda()
          )
        ))
        embed(ramp_while(
          function() return wire_count() == 1 and wiring_status() == "target bad" or wiring_status() == "target okay" end,
          do_all(
            announce_lambda("Click on the other magnet to connect the wire.", 0.06),
            announce_lambda("When a magnet receives a signal, it holds on to whatever is in front of it.", 0.05, default_vertical - 0.07),
            draw_corresponding_output_lambda()
          )
        ))
      end
      if wire_count() == 2 then
        set_user_input_filter(only_play_or_cancel_filter)
        embed(ramp_while(function() return is_wire_open() and wire_count() == 2 end, do_all(
          announce_lambda("Right click far from a wire to close wiring panel.", 0.08),
          announce_lambda("(Or press Escape)", 0.06, default_vertical - 0.08)
        )))
      end
      embed(pause(0.01))
    end
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(pause(20))
    embed(ramp_while(function(fade) return speed_is_low() and fade.total < 3 end, do_all(
      announce_lambda("Remember that you can adjust the speed.", 0.08),
      highlight_menu_item_lambda("speed_control")
    )))
  end)
end
function tutorial_routine()
  if not played_in_past then
    return tutorial_routine_first()
  else
    return tutorial_routine_second()
  end
end
draw_interpreted_routine(tutorial_routine())
